	function [k, c, em, sigma_Mult] = GRAY_MARKEL_1(G, Z, P)

	%	Computes the coefficients for the Gray and Markel 
	%	1-multiplier structure.
	%
	%	k is the reflection coefficient and c is the  taps.
	%	em is +1 and 1 sections, em(1) is the section 
	%	furthers from the input and sigma_Mult is the 
	%	noise variance at the inputs of the multiplers.
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB 
	
	% 	Author: 		Lars Wanhammar 2011-02-11
	% 	Modified by: 	 
	% 	Copyright:		by authors - not released for commercial use
	% 	Version:		1
	% 	Known bugs:		 
	% 	Report bugs to:	Wanhammar@gmail.com

	[k, c, alfa] = GRAY_MARKEL_2(G, Z, P);
	Index = find(abs(k) == max(abs(k)));
	Q = 1; 
	N = length(P);	% sign parameters em
	if Index ~= 1
		for m = Index-1:-1:1
			q = sqrt((1+abs(k(m)))/(1-abs(k(m))));
			if Q*q < 1  
				em(m) = sign(k(m)); Q = Q/q; 
			else
				em(m) = -sign(k(m)); Q = Q*q;
			end
		end
	end
	for m = Index:N
		q = sqrt((1+abs(k(m)))/(1-abs(k(m)))); 
		if Q*q > 1 
			em(m) = sign(k(m));		Q = Q/q;
		else
			em(m) = -sign(k(m));	Q = Q*q;
		end
	end 	
	p(N+1) = 1;
	for m = 1:N
		p(m) = 1;
		for n = m:N
			p(m) = p(m)*(1+em(n)*k(n));
		end
	end
	c = c./p';	% New tap values
	alfa(N+1) = 1;
	for m = N:-1:1
		alfa(m+1) = alfa(m)*(1-k(m)^2);
	end
	%	Variance ratio at the node values, i.e., sigma_i/sigma_x
	sigma = p.^2'.*alfa;
	% Variance at the inputs to the multipliers
	for n = 1:length(sigma)-1
		sigma_Mult(n) = sigma(n)*(2/(1+em(n)*k(n)));
	end
